<?php

namespace App\Lib;

use App\Models\Referral;
use App\Models\Transaction;
use App\Models\User;

class CompoundHyip {
    /**
     * @var User
     */
    private $user;

    /**
     * @var mixed
     */
    private $setting;

    /**
     * Create a new class instance.
     *
     * @param User $user
     */
    public function __construct(User $user) {
        $this->user    = $user;
        $this->setting = gs();
    }

    /**
     * Distribute referral commissions based on levels.
     *
     * @param User   $user
     * @param float  $amount
     * @param string $commissionType
     * @param string $trx
     * @param mixed  $setting
     */
    public static function levelCommission(User $user, float $amount, string $commissionType, string $trx, $setting): void {
        $meUser       = $user;
        $i            = 1;
        $level        = Referral::where('commission_type', $commissionType)->count();
        $transactions = [];

        while ($i <= $level) {
            $refer = $meUser->referrer;

            if (empty($refer)) {
                break;
            }

            $commission = Referral::where('commission_type', $commissionType)->where('level', $i)->first();

            if (!$commission) {
                break;
            }

            $com = ($amount * $commission->percent) / 100;
            $refer->balance += $com;
            $refer->save();

            // Determine commission type name
            $comType = match ($commissionType) {
                'deposit_commission' => 'Deposit',
                'invest_return_commission' => 'Investment Return',
                default => 'Investment',
            };

            $transactions[] = [
                'user_id'      => $refer->id,
                'amount'       => $com,
                'post_balance' => $refer->balance,
                'charge'       => 0,
                'trx_type'     => '+',
                'details'      => "Level {$i} Referral Commission from {$user->username} for {$comType}",
                'trx'          => $trx,
                'remark'       => 'referral_commission',
                'created_at'   => now(),
            ];

            notify($refer, 'REFERRAL_COMMISSION', [
                'amount'       => showAmount($com, currencyFormat: false),
                'post_balance' => showAmount($refer->interest_wallet, currencyFormat: false),
                'trx'          => $trx,
                'level'        => ordinal($i),
                'type'         => $comType,
            ]);

            $meUser = $refer;
            $i++;
        }

        if (!empty($transactions)) {
            Transaction::insert($transactions);
        }
    }
}
