<?php

namespace App\Models;

use App\Constants\Status;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;

class Contribution extends Model
{
    public function investment()
    {
        return $this->belongsTo(Investment::class);
    }

    // scope 
    public function scopePaid($query)
    {
        return $query->where('status', Status::CONTRIBUTION_PAID);
    }

    public function scopeUnpaid($query)
    {
        return $query->where('status', Status::CONTRIBUTION_UNPAID);
    }

    public function contributionStatusBadge(): Attribute
    {
        return new Attribute(
            get: fn () => $this->contributionStatusBadgeData(),
        );
    }

    public function contributionStatusBadgeData()
    {
        $html = '';
        if ($this->status == Status::CONTRIBUTION_PAID) {
            $html = '<span class="badge custom--badge badge--success">' . trans('Paid') . '</span>';
        } else if ($this->status == Status::CONTRIBUTION_UNPAID){
            $html = '<span class="badge custom--badge badge--danger">' . trans('Unpaid') . '</span>';
        }
        return $html;
    }
}
