@extends('admin.layouts.app')
@section('panel')
    <div class="row gy-3 mb-3">
        <div class="col-xl-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">@lang('User & Investment Info')</h5>
                </div>
                <div class="card-body">
                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between">
                            @lang('Transaction ID')
                            <span><strong>{{ $investment->trx }}</strong></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            @lang('Status')
                            <div class="text-end">
                                @php echo $investment->investStatusBadgeData() @endphp
                            </div>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            @lang('Full Name')
                            <span class="fw-bold">{{ $investment->user->fullname }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            @lang('Username')
                            <a class="text--primary" href="{{ route('admin.users.detail', $investment->user_id) }}">
                                <span class="text--primary">@</span>{{ __($investment->user?->username ?? null) }}
                            </a>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            @lang('Email')
                            <span class="fw-bold">{{ $investment->user->email }}</span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="col-xl-4 col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">@lang('Contribution Details')</h5>
                </div>
                <div class="card-body">
                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between">
                            @lang('Initial Deposit')
                            <span class="fw-bold">{{ showAmount($investment->initial_deposit) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            @lang('Recurring Contribution')
                            <span class="fw-bold">{{ showAmount($investment->contribution_amount) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            @lang('Contribution Frequency')
                            <span class="fw-bold">
                                @if ($investment->contribution_frequency == Status::DAILY_FREQUENCY)
                                    @lang('Daily')
                                @elseif($investment->contribution_frequency == Status::WEEKLY_FREQUENCY)
                                    @lang('Weekly')
                                @elseif($investment->contribution_frequency == Status::MONTHLY_FREQUENCY)
                                    @lang('Monthly')
                                @elseif($investment->contribution_frequency == Status::ANNUALLY_FREQUENCY)
                                    @lang('Annually')
                                @endif
                            </span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            @lang('Next Contribution Date')
                            <span class="fw-bold">{{ showDateTime($investment->next_contribution_date) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            @lang('Years to Grow')
                            <span class="fw-bold">{{ $investment->duration_years }} @lang('years')</span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="col-xl-4 col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">@lang('Returns & Growth')</h5>
                </div>
                <div class="card-body">
                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between">
                            @lang('Annual Return Rate')
                            <span class="fw-bold">{{ getAmount($investment->annual_return_rate) }}%</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            @lang('Total Return Amount')
                            <span class="fw-bold">{{ showAmount($investment->total_return) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            @lang('Start Date')
                            <span class="fw-bold">{{ showDateTime($investment->start_date) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            @lang('End Date')
                            <span class="fw-bold">{{ showDateTime($investment->end_date) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between">
                            @lang('Total Paid Contributions')
                            <span class="fw-bold">{{ $investment->paid_contribution }}(@lang('Out of '){{ $investment->contribution_count }})</span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    @if ($investment->close_request_status == Status::CLOSE_STATUS_APPROVED)
        <div class="form-group alert alert-success p-3">
            <span class="fw-bold text-dark">@lang('The investment close request has been approved')</span>
        </div>
    @elseif($investment->close_request_status == Status::CLOSE_STATUS_REJECTED)
        <div class="form-group alert alert-danger p-3">
            <span class="fw-bold text-dark">@lang('The investment close request has been rejected')</span>
        </div>
    @endif
    <div class="row mt-4">
        <div class="col-lg-12">

            <div class="d-flex justify-content-between align-items-center mb-4 flex-wrap gap-2">
                <h5 class="mb-0">@lang('All Contributions')</h5>
                <x-search-form placeholder="Transaction Id" dateSearch='yes' />
            </div>

            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('Transaction ID')</th>
                                    <th class="text-center">@lang('Contribution Amount')</th>
                                    <th class="text-center">@lang('Penalty Amount')</th>
                                    <th class="text-center">@lang('Status')</th>
                                    <th class="text-center">@lang('Contributed At')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($contributions as $contribution)
                                    <tr>
                                        <td>
                                            <span class="fw-bold">{{ $contribution->trx }}</span>
                                            <br>
                                            <small class="text-muted">{{ showDateTime($contribution->created_at) }}</small>
                                        </td>
                                        <td class="text-center">
                                            {{ showAmount($contribution->amount) }}
                                        </td>
                                        <td class="text-center">
                                            {{ showAmount($contribution->penalty_amount) }}
                                        </td>
                                        <td class="text-center">
                                            @php echo $contribution->contributionStatusBadge @endphp
                                        </td>
                                        <td class="text-center">
                                            {{ showDateTime($contribution->created_at) }} <br>
                                            {{ diffForHumans($contribution->created_at) }}
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="100%" class="text-muted text-center">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                @if ($contributions->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($contributions) }}
                    </div>
                @endif
            </div>
        </div>
    </div>
    <x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')
    <div href="javascript:void(0)" class="d-flex justify-content-start mx-3 my-4 gap-2">
        <a data-action="{{ route('admin.investment.close.request.approve', $investment->id) }}"
            data-question="@lang('Are you sure to approve the investment close request?')"
            class="btn btn-outline--success confirmationBtn {{ in_array($investment->close_request_status, [Status::CLOSE_STATUS_APPROVED, Status::CLOSE_STATUS_REJECTED]) ? 'd-none' : '' }}">
            <i class="fas fa-check"></i>
            @lang('Approve')
        </a>
        <a href="javascript:void(0)"
            data-action="{{ route('admin.investment.close.request.reject', $investment->id) }}"
            data-question="@lang('Are you sure to reject the investment close request?')"
            class="btn btn-outline--danger confirmationBtn {{ in_array($investment->close_request_status, [Status::CLOSE_STATUS_APPROVED, Status::CLOSE_STATUS_REJECTED]) ? 'd-none' : '' }}">
            <i class="fas fa-times"></i>
            @lang('Reject')
        </a>
    </div>
@endpush
