<header class="header" id="header">
    <div class="container">
        <nav class="navbar navbar-expand-lg navbar-light">
            <a class="navbar-brand logo" href="{{ route('home') }}"><img src="{{ siteLogo() }}" alt="logo"></a>
            <button class="navbar-toggler header-button" type="button" data-bs-toggle="collapse"
                    data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false"
                    aria-label="Toggle navigation">
                <span id="hiddenNav"><i class="las la-bars"></i></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav nav-menu ms-auto align-items-lg-center">
                    <li class="nav-item {{ menuActive('home') }}">
                        <a class="nav-link" aria-current="page" href="{{ route('home') }}">@lang('Home')</a>
                    </li>
                    @php
                        $pages = App\Models\Page::where('tempname', $activeTemplate)->where('is_default', Status::NO)->get();
                    @endphp
                    @foreach ($pages as $k => $data)
                        <li class="nav-item {{ menuActive('pages', [$data->slug]) }}">
                            <a class="nav-link" aria-current="page" href="{{ route('pages', [$data->slug]) }}">
                                {{ __($data->name) }}
                            </a>
                        </li>
                    @endforeach
                    <li class="nav-item {{ menuActive('invest') }}">
                        <a class="nav-link" aria-current="page" href="{{ route('invest') }}">@lang('Invest')</a>
                    </li>
                    <li class="nav-item {{ menuActive('blog') }}">
                        <a class="nav-link" aria-current="page" href="{{ route('blog') }}">@lang('Blog')</a>
                    </li>
                    <li class="nav-item {{ menuActive('contact') }}">
                        <a class="nav-link" aria-current="page" href="{{ route('contact') }}">@lang('Contact')</a>
                    </li>

                    <li class="nav-item order-lg-last order-first">
                        <div class="top-button d-flex flex-wrap justify-content-between align-items-center">
                            @if (gs('multi_language'))
                                @php
                                    $language = App\Models\Language::all();
                                    $activeLanguage = App\Models\Language::where('code', session('lang'))->first();
                                @endphp

                                <div class="language-dropdown">
                                    <div class="language-dropdown__selected">
                                        <span class="thumb"> <img class="flag"
                                                 src="{{ getImage(getFilePath('language') . '/' . $activeLanguage->image, getFileSize('language')) }}"
                                                 alt="img"></span>
                                        <span class="text">{{ $activeLanguage->name }}</span>
                                    </div>
                                    <ul class="language-dropdown__list">
                                        @foreach ($language as $item)
                                            <li class="language-dropdown__list-item langSel"
                                                data-value="{{ $item->code }}">
                                                <span class="thumb"> <img class="flag"
                                                         src="{{ getImage(getFilePath('language') . '/' . $item->image, getFileSize('language')) }}"
                                                         alt="img"></span>
                                                <span class="text">{{ $item->name }}</span>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif
                            <div class="user-info">
                                <button class="user-info__button flex-align gap-2" type="button" id="userDropdown">
                                    <span class="user-info__thumb">
                                        <img src="{{ auth()->user()->imageSrc }}" class="fit-image"
                                             alt="@lang('image')">
                                    </span>
                                    <span class="user-profile__name text-white fw-bold">{{ auth()->user()->fullname }}</span>
                                </button>
                                <ul class="user-info-dropdown">
                                    <li class="user-info-dropdown__item">
                                        <a class="user-info-dropdown__link" href="{{ route('user.profile.setting') }}">
                                            <span class="icon"><i class="far fa-user"></i></span>
                                            <span class="text">@lang('Profile')</span>
                                        </a>
                                    </li>
                                    <li class="user-info-dropdown__item">
                                        <a class="user-info-dropdown__link" href="{{ route('user.change.password') }}">
                                            <span class="icon"><i class="fas fa-key"></i></span>
                                            <span class="text">@lang('Password')</span>
                                        </a>
                                    </li>
                                    <li class="user-info-dropdown__item">
                                        <a class="user-info-dropdown__link" href="{{ route('user.logout') }}">
                                            <span class="icon"><i class="fas fa-sign-out-alt"></i></span>
                                            <span class="text">@lang('Logout')</span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </li>
                </ul>
            </div>
        </nav>
    </div>
</header>
