<div class="row gy-4 justify-content-center ">
    @forelse ($blogs as $index => $element)
        <div class="col-md-6 col-xl-4">
            <a class="blog-item wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.3s"
                href="{{ route('blog.details', $element->slug) }}">
                <div class="blog-item__wrapper">
                    <img class="blog-item__image"
                        src="{{ frontendImage('blog', 'thumb_' . $element->data_values?->image ?? '', '430x245') }}"
                        alt="blog-left">
                    <div class="blog-item__content">
                        <h5 class="blog-item__title">
                            {{ __(strLimit($element->data_values?->title ?? '', 50)) }}
                        </h5>
                        <p class="blog-item__desc">
                            @php echo __(strLimit(strip_tags($element->data_values?->description ?? ''), 75)) @endphp
                        </p>
                        <div class="blog-item__info">
                            <div class="flex-grow-1">
                                <p class="blog-item__subdesc">
                                    <i class="fa-regular fa-clock"></i>
                                    {{ showDateTime($element->created_at, 'd M Y') }}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </a>
        </div>
    @empty
        <div class="card custom--card">
            <div class="card-body">
                <div class="text-center">
                    <h5 class="text--white">@lang('No blogs found.')</h5>
                </div>
            </div>
        </div>
    @endforelse
</div>
