@php
    $policyPages = getContent('policy_pages.element', false, orderById: true);
    $footer = getContent('footer.content', true);
    $contact = getContent('contact_us.content', true);
@endphp


<footer class="footer-area bg-img" data-background-image="{{ frontendImage('footer', $footer->data_values?->background_image ?? '', '1920x465') }}">
    <img class="footer-area__coin-right" src="{{ getImage($activeTemplateTrue . 'images/coin/footer-left.png') }}" alt="@lang('coin')">
    <img class="footer-area__coin-left" src="{{ getImage($activeTemplateTrue . 'images/coin/footer-right.png') }}" alt="@lang('coin')">
    <div class="container">
        <div class="top-footer">
            <div class="row justify-content-center gy-5">
                <div class="col-xl-4 col-sm-6 col-xsm-6">
                    <div class="footer-item">
                        <div class="footer-item__logo">
                            <a href="{{ route('home') }}"> <img src="{{ siteLogo() }}" alt="logo"></a>
                        </div>
                        <p class="footer-item__desc"> {{ __($footer->data_values?->short_description ?? '') }} </p>
                    </div>
                </div>
                <div class="col-xl-2 col-sm-6 col-xsm-6">
                    <div class="footer-item">
                        <h5 class="footer-item__title">@lang('Quick Links')</h5>
                        <ul class="footer-menu">
                            <li class="footer-menu__item"><a href="{{ route('invest') }}" class="footer-menu__link"><i class="fa-solid fa-caret-right"></i> @lang('Invest') </a></li>
                            <li class="footer-menu__item"><a href="{{ route('blog') }}" class="footer-menu__link"><i class="fa-solid fa-caret-right"></i> @lang('Blog') </a></li>
                            <li class="footer-menu__item"><a href="{{ route('contact') }}" class="footer-menu__link"><i class="fa-solid fa-caret-right"></i>@lang('Contact')</a></li>
                        </ul>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6 col-xsm-6">
                    <div class="footer-item">
                        <h5 class="footer-item__title">@lang('Privacy & Policy')</h5>
                        <ul class="footer-menu">
                            @foreach ($policyPages as $policy)
                                <li class="footer-menu__item">
                                    <a href="{{ route('policy.pages', $policy->slug) }}" class="footer-menu__link">
                                        <i class="fa-solid fa-caret-right"></i>{{ __($policy->data_values?->title ?? '') }}
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6 col-xsm-6">
                    <div class="footer-item">
                        <h5 class="footer-item__title">{{ __($contact->data_values?->title ?? '') }}</h5>
                        <ul class="footer-contact-menu">
                            <li class="footer-contact-menu__item">
                                <div class="footer-contact-menu__item-icon">
                                    <i class="fas fa-map-marker-alt"></i>
                                </div>
                                <div class="footer-contact-menu__item-content">
                                    <p>{{ __($contact->data_values?->contact_address ?? '') }}</p>
                                </div>
                            </li>
                            <li class="footer-contact-menu__item">
                                <div class="footer-contact-menu__item-icon">
                                    <i class="fas fa-envelope"></i>
                                </div>
                                <div class="footer-contact-menu__item-content">
                                    <a class="footer-email"
                                       href="mailto:{{ $contact->data_values?->email_address ?? '' }}">{{ $contact->data_values?->email_address ?? '' }}</a>
                                </div>
                            </li>
                            <li class="footer-contact-menu__item">
                                <div class="footer-contact-menu__item-icon">
                                    <i class="fas fa-phone"></i>
                                </div>
                                <div class="footer-contact-menu__item-content">
                                    <a class="footer-phone"
                                       href="tel:{{ $contact->data_values?->contact_number ?? '' }}">{{ $contact->data_values?->contact_number ?? '' }}</a>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <div class="bottom-footer">
            <div class="container">
                <div class="text-center">
                    <div class="bottom-footer-text text-white"> @lang('Copyright') &copy;
                        <a href="{{ route('home') }}" class="text--base">{{ __(@gs('site_name')) }}</a> {{ date('Y') }} @lang('All Right Reserved.')
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>
