<header class="header" id="header">
    <div class="container">
        <nav class="navbar navbar-expand-lg navbar-light">
            <a class="navbar-brand logo" href="{{ route('home') }}"><img src="{{ siteLogo() }}" alt="logo"></a>
            <button class="navbar-toggler header-button" type="button" data-bs-toggle="collapse"
                    data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false"
                    aria-label="Toggle navigation">
                <span id="hiddenNav"><i class="las la-bars"></i></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav nav-menu ms-auto align-items-lg-center">
                    <li class="nav-item {{ menuActive('home') }}">
                        <a class="nav-link" href="{{ route('home') }}">@lang('Home')</a>
                    </li>
                    @foreach ($pages as $k => $data)
                        <li class="nav-item @if ($data->slug == Request::segment(1)) active @endif">
                            <a class="nav-link" href="{{ route('pages', $data->slug) }}">{{ __($data->name) }}</a>
                        </li>
                    @endforeach
                    <li class="nav-item {{ menuActive('invest') }}">
                        <a class="nav-link" href="{{ route('invest') }}">@lang('Invest')</a>
                    </li>
                    <li class="nav-item {{ menuActive('blog') }}">
                        <a class="nav-link" href="{{ route('blog') }}">@lang('Blog')</a>
                    </li>
                    <li class="nav-item {{ menuActive('contact') }}">
                        <a class="nav-link" href="{{ route('contact') }}">@lang('Contact')</a>
                    </li>
                    <li class="nav-item order-lg-last order-first">
                        <div class="top-button d-flex flex-wrap justify-content-between align-items-center">
                            @if (gs('multi_language'))
                                @php
                                    $language = App\Models\Language::all();
                                    $activeLanguage = App\Models\Language::where('code', session('lang'))->first();
                                @endphp
                                <div class="language-dropdown">
                                    <div class="language-dropdown__selected">
                                        <span class="thumb">
                                            <img class="flag" src="{{ getImage(getFilePath('language') . '/' . $activeLanguage->image ?? '', getFileSize('language')) }}" alt="img">
                                        </span>
                                        <span class="text">{{ $activeLanguage->name }}</span>
                                    </div>
                                    <ul class="language-dropdown__list">
                                        @foreach ($language as $item)
                                            <li class="language-dropdown__list-item langSel"
                                                data-value="{{ $item->code }}">
                                                <span class="thumb"> <img class="flag" src="{{ getImage(getFilePath('language') . '/' . $item->image ?? '', getFileSize('language')) }}" alt="img"></span>
                                                <span class="text">{{ $item->name }}</span>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif
                            <ul class="login-registration-list flex-center">
                                @guest
                                    <li class="login-registration-list__item">
                                        <a href="{{ route('user.login') }}" class="login-registration-list__link login-link {{ menuActive('user.login') }}">@lang('Login')</a>
                                    </li>
                                    <li class="login-registration-list__item">
                                        <a href="{{ route('user.register') }}" class="login-registration-list__link login-link {{ menuActive('user.register') }}">@lang('Register')</a>
                                    </li>
                                @endguest
                                @auth
                                    <li class="login-registration-list__item">
                                        <a href="{{ route('user.home') }}" class="login-registration-list__link login-link">@lang('Dashboard')</a>
                                    </li>
                                    <li class="login-registration-list__item">
                                        <a href="{{ route('user.logout') }}" class="login-registration-list__link login-link">@lang('Logout')</a>
                                    </li>
                                @endauth
                            </ul>
                        </div>
                    </li>
                </ul>
            </div>
        </nav>
    </div>
</header>
