@php
    $faqContent = getContent('faq.content', true);
    $faqElements = getContent('faq.element', orderById: true);
    $chunks = $faqElements->chunk(ceil($faqElements->count() / 2));
@endphp

<section class="faq-section py-100 bg-img"
    data-background-image="{{ frontendImage('faq', $faqContent->data_values?->background_image ?? '', '1905x960') }}">
    <div class="container custom--container">
        <div class="section-heading fadeIn" data-wow-duration="0.5s" data-wow-delay="0.3s">
            <h2 class="section-heading__title wow fadeInUp" data-wow-duration="0.5s" data-highlight="-2_-1">
                {{ __($faqContent->data_values?->title ?? '') }}</h2>
            <p class="section-heading__desc wow fadeInUp" data-wow-duration="0.5s">
                {{ __($faqContent->data_values?->subtitle ?? '') }}</p>
        </div>

        <div id="faq-accordion" class="accordion custom--accordion wow fadeIn" data-wow-duration="0.5s" data-wow-delay="0.3s">
            <div class="row gy-4">
                @foreach ($chunks as $chunkIndex => $faqs)
                    <div class="col-lg-6">
                        @foreach ($faqs as $faqIndex => $faq)
                            @php
                                $isFirst = $chunkIndex === 0 && $faqIndex === 0;
                            @endphp
                            <div class="accordion-item wow fadeInLeft" data-wow-duration="0.5s" data-wow-delay="0.3s">
                                <h2 class="accordion-header">
                                    <button class="accordion-button {{ !$isFirst ? 'collapsed' : '' }}" type="button"
                                        data-bs-toggle="collapse"
                                        data-bs-target="#faq-accordion-item-{{ $faq->id }}"
                                        aria-expanded="{{ $isFirst ? 'true' : 'false' }}"
                                        aria-controls="faq-accordion-item-{{ $faq->id }}">
                                        <span class="accordion-button__icon"></span>
                                        {{ __($faq->data_values?->question ?? '') }}
                                    </button>
                                </h2>
                                <div id="faq-accordion-item-{{ $faq->id }}"
                                    class="accordion-collapse collapse {{ $isFirst ? 'show' : '' }}"
                                    data-bs-parent="#faq-accordion">
                                    <div class="accordion-body">
                                        <p class="accordion-text">{{ __($faq->data_values?->answer ?? '') }}</p>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</section>
