@php
    $workContent = getContent('how_it_works.content', true);
    $workElements = getContent('how_it_works.element', orderById: true, limit: 4);
@endphp

<section class="how-it-works py-100">
    <div class="how-it-works-bg">
        <span class="how-it-works-bg__light one"></span>
        <span class="how-it-works-bg__light two"></span>
        <span class="how-it-works-bg__light three"></span>
    </div>

    <div class="container">
        <div class="section-heading wow fadeIn" data-wow-duration="0.5s" data-wow-delay="0.3s">
            <h2 class="section-heading__title wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.3s"
                data-highlight="-2_-1">{{ __($workContent->data_values?->title ?? '') }}</h2>
            <p class="section-heading__desc wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.3s">
                {{ __($workContent->data_values?->description ?? '') }}</p>
        </div>
        <div class="how-it-works-grid wow fadeIn" data-wow-duration="0.5s" data-wow-delay="0.3s">
            @foreach ($workElements as $index => $workElement)
                <div class="how-it-works-card {{ ($index + 1) % 2 == 1 ? 'reverse' : '' }}">
                    <span class="how-it-works-card__icon wow fadeIn" data-wow-duration="0.5s" data-wow-delay="0.3s">
                        @php echo $workElement->data_values?->icon ?? '' @endphp
                    </span>
                    <div class="how-it-works-card__content">
                        <h4 class="how-it-works-card__title wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.3s">
                            {{ ++$index }}.{{ __($workElement->data_values?->title ?? '') }}</h4>
                        <p class="how-it-works-card__desc wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.3s">{{ __($workElement->data_values?->description ?? '') }}</p>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>
