@php
    $paymentContent = getContent('payment.content', true);
    $paymentElements = getContent('payment.element', orderById: true);
@endphp

<section class="payment-section py-100">
    <div class="container position-relative">
        <div class="payment-coins">
            <span class="payment-coins_one"><img src="{{ getImage($activeTemplateTrue . 'images/coin/payment-coin1.png') }}"
                    alt="@lang('coin')"></span>
            <span class="payment-coins_two"><img src="{{ getImage($activeTemplateTrue . 'images/coin/payment-coin2.png') }}"
                    alt="@lang('coin')"></span>
            <span class="payment-section__light"></span>
        </div>
        <div class="section-heading wow fadeIn" data-wow-duration="0.5s" data-wow-delay="0.3s">
            <h2 class="section-heading__title wow fadeInUp" data-wow-duration="0.5s" data-highlight="-2_-1">{{ __($paymentContent->data_values?->heading ?? '') }}</h2>
            <p class="section-heading__desc wow fadeInUp" data-wow-duration="0.5s">{{ __($paymentContent->data_values?->subheading ?? '') }}</p>
        </div>
        <div class="payment-slider__items wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.3s">
            @foreach ($paymentElements as $paymentElement)
                <div class="payment-slider__item">
                    <img src="{{ frontendImage('payment', $paymentElement->data_values?->image ?? '', '170x75') }}" alt="@lang('logo')">
                </div>
            @endforeach
        </div>
    </div>
</section>

@push('style-lib')
    <!-- Slick -->
    <link rel="stylesheet" href="{{ asset($activeTemplateTrue . 'css/slick.css') }}">
@endpush


@push('script-lib')
    <!-- Slick js -->
    <script src="{{ asset($activeTemplateTrue . 'js/slick.min.js') }}"></script>
@endpush
