@php
    $subscriberContent = getContent('subscribe.content', true);
@endphp

<section class="subscribe-section">
    <div class="subscribe-section__light"></div>
    <div class="container">
        <div class="subscribe-section__inner bg-img" data-background-image="{{ frontendImage('subscribe', $subscriberContent->data_values?->background_image ?? '', '1300X210') }}">
            <div class="subscribe-section__content">
                <h4 class="subscribe-section__title mb-0" data-highlight="-1">{{ __($subscriberContent->data_values?->heading ?? '') }}</h4>
                <p class="subscribe-section__desc">{{ __($subscriberContent->data_values?->subheading ?? '') }}</p>
            </div>
            <form class="subscribe-form">
                @csrf
                <div class="form--control-wrapper">
                    <input type="email" name="email" class="form--control" placeholder="@lang('Write your email...')" required>
                    <button class="btn btn--base subscribe-btn text-nowrap m-2">@lang('Subscribe')</button>
                </div>
            </form>
        </div>
    </div>
</section>

@push('script')
    <script>
        'use strict';
        (function($) {
            $('.subscribe-form').on('submit', function(event) {
                event.preventDefault();
                const formData = new FormData($(this)[0]);
                $.ajax({
                    url: "{{ route('subscribe') }}",
                    type: "POST",
                    cache: false,
                    contentType: false,
                    processData: false,
                    data: formData,
                    success: function(response) {
                        $('.subscribe-form').trigger('reset');
                        if (response.success) {
                            notify('success', response.message);
                        } else {
                            notify('error', response.message);
                        }
                    }
                });
            });
        })(jQuery);
    </script>
@endpush
