@php
    $topInvestorContent = getContent('top_investor.content', true);
    $topInvestorElements = getContent('top_investor.element', orderById: true);
@endphp
<section class="invest-section py-100 position-relative">
    <div class="invest-section__light"></div>
    <div class="container">
        <div class="row">
            <div class="col-12 ">
                <div class="section-heading wow fadeIn" data-wow-duration="0.5s" data-wow-delay="0.3s">
                    <h2 class="section-heading__title text-center wow fadeInUp" data-wow-duration="0.5s"
                        data-wow-delay="0.3s" data-highlight="-1">
                        {{ __($topInvestorContent->data_values?->title ?? '') }}
                    </h2>
                    <p class="section-heading__desc text-center wow fadeInUp" data-wow-duration="0.5s"
                        data-wow-delay="0.3s">{{ __($topInvestorContent->data_values?->subtitle ?? '') }}</p>
                </div>
            </div>
        </div>
        <div class="row justify-content-center">
            @foreach ($topInvestorElements as $index => $topInvestorElement)
                <div class="col-xl-4 col-lg-6 col-md-6  ">
                    <div class="invest-items wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.3s">
                        <span class="invest-items__light"></span>
                        <div class="invest-items__image">
                            <img src="{{ frontendImage('top_investor', $topInvestorElement->data_values?->image ?? '', '130x108') }}"
                                alt="@lang('investor')">
                        </div>
                        <div class="invest-items_content">
                            <div class="invest-items__subtitles">
                                <p class="invest-items__subtitle">
                                    {{ __($topInvestorElement->data_values?->username ?? '') }}</p>
                                @if ($index < 3)
                                    <div class="invest-items__icons">
                                        <span class="invest-items__stamp">{{ ++$index }}</span>
                                        <img class="invest-items__icon "
                                            src="{{ getImage($activeTemplateTrue . 'images/icons/invest-batch.png') }}"
                                            alt="investor">
                                    </div>
                                @else
                                    <p class="invest-items__point">{{ ++$index . 'th' }}</p>
                                @endif
                            </div>
                            <h3 class="invest-items__title">{{ __($topInvestorElement->data_values?->name ?? '') }}</h3>
                            <h4 class="invest-items__title-bottom">@lang('Return:') {{ gs('cur_sym') }}
                                {{ __($topInvestorElement->data_values?->invest_amount ?? '') }}</h4>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>
