@php
    $transactionContent = getContent('transaction.content', true);
    $latestDeposits = App\Models\Deposit::with('gateway')
        ->latest()
        ->where('status', Status::PAYMENT_SUCCESS)
        ->take(10)
        ->get(['amount', 'method_code', 'created_at']);
    $latestWithdrawals = App\Models\Withdrawal::with('method')
        ->latest()
        ->where('status', Status::PAYMENT_SUCCESS)
        ->take(10)
        ->get(['amount', 'method_id', 'created_at']);
@endphp
<section class="transation-section py-100 position-relative  bg-img position-relative "
    data-background-image="{{ frontendImage('transaction', $transactionContent->data_values?->background_image ?? '', '1905x960') }}">
    <div class="transation-section__light">
    </div>

    <div class="transation-section__coins">
        <div class="transation-section__coins__coinone"><img
                src="{{ getImage($activeTemplateTrue . 'images/coin/tr1.png') }}" alt="@lang('coin')"></div>
        <div class="transation-section__coins__cointwe "><img
                src="{{ getImage($activeTemplateTrue . 'images/coin/tr2.png') }}" alt="@lang('coin')"></div>
        <div class="transation-section__coins__cointhree"><img
                src="{{ getImage($activeTemplateTrue . 'images/coin/tr3.png') }}" alt="@lang('coin')"></div>
        <div class="transation-section__coins__coinfour "><img
                src="{{ getImage($activeTemplateTrue . 'images/coin/tr2.png') }}" alt="@lang('coin')"></div>
    </div>
    <div class="container">
        <div class="section-heading text-center ">
            <h2 class="section-heading__title" data-highlight="-1">
                {{ __($transactionContent->data_values?->title ?? '') }}</h2>
            <p class="section-heading__desc m-auto">{{ __($transactionContent->data_values?->subtitle ?? '') }}</p>
        </div>

        <div class="row">
            <div class="col-lg-6 position-relative ">
                <div class="wow fadeInLeft" data-wow-duration="0.5s" data-wow-delay="0.3s">
                    <div class="transation-card__icon">
                        <img src="{{ getImage($activeTemplateTrue . 'images/icons/tr-icon.png') }}"
                            alt="@lang('transation-img')">
                    </div>
                    <div class="transation-card">
                        <h3 class="transation-card__title">
                            @lang('Latest Deposit')
                        </h3>
                        <div class="transation-card__content">
                            <div class="transation-card__subtitle">
                                <h5 class="transation-card__subtitle-el transation-card__left-subtitle">
                                    @lang('Gateway')</h5>
                                <h5 class="transation-card__subtitle-el transation-card__center-subtitle">
                                    @lang('Date')</h5>
                                <h5 class="transation-card__subtitle-el transation-card__right-subtitle">
                                    @lang('Amount')</h5>
                            </div>
                            @if (!blank($latestDeposits))
                                <div class="table-list">
                                    @foreach ($latestDeposits as $latestDeposit)
                                        <div class="transation-card__item">
                                            <p class="transation-card__item-desc"> <span
                                                    class="transation-card__item-title">@lang('Gateway')</span>
                                                {{ __($latestDeposit->gateway->name ?? '') }}
                                            </p>
                                            <p class="transation-card__item-desc"> <span
                                                    class="transation-card__item-title">@lang('Date')</span>
                                                {{ showDateTime($latestDeposit->created_at) }}
                                            </p>
                                            <p class="transation-card__item-desc"> <span
                                                    class="transation-card__item-title">@lang('Amount')</span>
                                                {{ showAmount($latestDeposit->amount) }}
                                            </p>
                                        </div>
                                    @endforeach
                                </div>
                            @else
                                <div class="mt-4">
                                    @include($activeTemplate . 'partials.empty', [
                                        'message' => 'Deposit not found',
                                    ])
                                </div>
                            @endif
                        </div>
                        <div class="transation-card__thumb">
                            <img src="{{ frontendImage('transaction', $transactionContent->data_values?->deposit_down_image ?? '', '640x75') }}"
                                alt="@lang('transation-img')">
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-6 position-relative ">
                <div class="wow fadeInRight" data-wow-duration="0.5s" data-wow-delay="0.3s">
                    <div class="transation-card__icon">
                        <img src="{{ getImage($activeTemplateTrue . 'images/thumbs/t.image.png') }}"
                            alt="@lang('transation-img')">
                    </div>
                    <div class="transation-card">
                        <h3 class="transation-card__title">
                            @lang('Latest Withdrawals')
                        </h3>
                        <div class="transation-card__content">
                            <div class="transation-card__subtitle">
                                <h5 class="transation-card__subtitle-el transation-card__left-subtitle">
                                    @lang('Gateway')
                                </h5>
                                <h5 class="transation-card__subtitle-el transation-card__center-subtitle">
                                    @lang('Date')
                                </h5>
                                <h5 class="transation-card__subtitle-el transation-card__right-subtitle">
                                    @lang('Amount')
                                </h5>
                            </div>
                            @if (!blank($latestWithdrawals))
                                <div class="table-list">
                                    @foreach ($latestWithdrawals as $latestWithdrawal)
                                        <div class="transation-card__item">
                                            <p class="transation-card__item-desc"> <span
                                                    class="transation-card__item-title">@lang('Gateway')</span>
                                                {{ __($latestWithdrawal->method->name ?? '') }}</p>
                                            <p class="transation-card__item-desc"> <span
                                                    class="transation-card__item-title">@lang('Date')</span>
                                                {{ showDateTime($latestWithdrawal->created_at) }}
                                            </p>
                                            <p class="transation-card__item-desc"> <span
                                                    class="transation-card__item-title">@lang('Amount')</span>
                                                {{ showAmount($latestWithdrawal->amount) }}
                                            </p>
                                        </div>
                                    @endforeach
                                </div>
                            @else
                                <div class="mt-4">
                                    @include($activeTemplate . 'partials.empty', [
                                        'message' => 'Withdrawals not found',
                                    ])
                                </div>
                            @endif
                        </div>
                        <div class="transation-card__thumb">
                            <img src="{{ frontendImage('transaction', $transactionContent->data_values?->withdraw_down_image ?? '', '640x75') }}"
                                alt="@lang('transation-img')">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
