@php
    $whyChooseUsContent = getContent('why_choose_us.content', true);
    $whyChooseUsElements = getContent('why_choose_us.element', orderById: false, limit: 6);
@endphp

<section class="why-choose py-100 bg-img" data-background-image="{{ frontendImage('why_choose_us', $whyChooseUsContent->data_values?->background_image ?? '', '1905x895') }}">
    <div class="why-choose__light one"></div>
    <div class="why-choose__light two"></div>
    <div class="container">
        <div class="section-heading wow fadeIn" data-wow-duration="0.5s" data-wow-delay="0.3s">
            <h2 class="section-heading__title wow fadeInDown" data-wow-duration="0.5s" data-wow-delay="0.3s" data-highlight="-2_-1">{{ __($whyChooseUsContent->data_values?->title ?? '') }}</h2>
            <p class="section-heading__desc wow fadeInDown" data-wow-duration="0.5s" data-wow-delay="0.3s">{{ __($whyChooseUsContent->data_values?->subtitle ?? '') }}</p>
        </div>

        <div class="why-choose-grid">
            <img class="why-choose-thumb wow bounceIn" data-wow-duration="0.5s" data-wow-delay="0.3s"  src="{{ frontendImage('why_choose_us', $whyChooseUsContent->data_values?->image ?? '', '415x490') }}" alt="@lang('features-image')">
            @foreach ($whyChooseUsElements as $index => $whyChooseUsElement)
                <div class="why-choose-list-item">
                    <span class="why-choose-list-item__bg"></span>
                    <span class="why-choose-list-item__icon mask-img" data-mask-image="{{ frontendImage('why_choose_us', $whyChooseUsElement->data_values?->image ?? '', '45x45') }}"></span>
                    <div class="why-choose-list-item__content">
                        <h4 class="why-choose-list-item__title">{{ __($whyChooseUsElement->data_values?->title ?? '') }}</h4>
                        <p class="why-choose-list-item__desc">{{ __($whyChooseUsElement->data_values?->description ?? '') }}</p>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>

@push('script')
    <script>
        (function($) {
            'use strict';

            function setWCGrid() {
                const wcGrid = $('.why-choose-grid');
                const wcListItems = $('.why-choose-list-item');
                const wcListItemsArray = Array.from(wcListItems);
                const wcListItemLength = wcListItems.length;
                const wcListItemCeil = Math.ceil(wcListItemLength / 2);
                const wcListItemFloor = Math.floor(wcListItemLength / 2);
                const wcListItemsFirstChunk = wcListItemsArray.slice(0, wcListItemCeil);
                const wcListItemsLastChunk = wcListItemsArray.slice(wcListItemFloor * -1);
                const wcListItemsFirstChunkWrapper = $('<div class="why-choose-list line-right wow fadeInLeft"></div>');
                const wcListItemsLastChunkWrapper = $('<div class="why-choose-list line-left wow fadeInRight"></div>');
                // Instead of cloning, detach and move the real element
                wcListItemsFirstChunk.forEach((el) => {
                    wcListItemsFirstChunkWrapper.append($(el).detach());
                });
                wcListItemsLastChunk.forEach((el) => {
                    wcListItemsLastChunkWrapper.append($(el).detach());
                });
                wcGrid.append([wcListItemsFirstChunkWrapper, wcListItemsLastChunkWrapper]);
            }

            setWCGrid();

        })(jQuery)
    </script>
@endpush
