@extends($activeTemplate . 'layouts.master')

@section('content')
    <form class="search-form w-sm-50 ms-auto mb-3">
        <div class="form--control-wrapper">
            <input type="search" name="search" class="form--control" value="{{ request()->search }}"
                placeholder="@lang('Search by transactions')">
            <button class="input-group-text bg-primary text-white">
                <i class="las la-search"></i>
            </button>
        </div>
    </form>
    @if (!blank($contributions))
        <div class="table-responsive">
            <table class="table custom--table table--responsive--lg">
                <thead>
                    <tr>
                        <th>@lang('TRX')</th>
                        <th class="text-center">@lang('Contribution Amount')</th>
                        <th class="text-center">@lang('Penalty Amount')</th>
                        <th class="text-center">@lang('Status')</th>
                        <th class="text-center">@lang('Contributed At')</th>
                    </tr>
                </thead>
                <tbody>

                    @forelse($contributions as $contribution)
                        <tr>
                            <td>
                                {{ $contribution->trx }}
                            </td>
                            <td class="text-center">
                                {{ showAmount($contribution->amount) }}
                            </td>
                            <td class="text-center">
                                {{ showAmount($contribution->penalty_amount) }}
                            </td>
                            <td class="text-center">
                                @php echo $contribution->contributionStatusBadge @endphp
                            </td>
                            <td class="text-center">
                                <div>
                                    {{ showDateTime($contribution->created_at) }} <br>
                                    {{ diffForHumans($contribution->created_at) }}
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    @else
        <div class="card custom--card">
            <div class="card-body">
                @include($activeTemplate . 'partials.empty', ['message' => 'No contributions yet'])
            </div>
        </div>
    @endif

    @if ($contributions->hasPages())
        <div class="pagination-wrapper">
            {{ paginateLinks($contributions) }}
        </div>
    @endif
@endsection
