@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="row gy-3 mb-4">
        <div class="col-xl-6 col-md-6">
            <div class="card custom--card h-100">
                <div class="card-header">
                    <h5 class="card-title mb-0">@lang('Investment Summary')</h5>
                </div>
                <div class="card-body">
                    <ul class="info-list">
                        <li class="info-list__item">
                            <span class="info-list__label">@lang('Transaction ID')</span>
                            <span class="info-list__value">{{ $investment->trx }}</span>
                        </li>
                        <li class="info-list__item">
                            <span class="info-list__label">@lang('Status')</span>
                            <span class="info-list__value">@php echo $investment->investStatusBadge @endphp</span>
                        </li>
                        <li class="info-list__item">
                            <span class="info-list__label">@lang('Initial Deposit')</span>
                            <span class="info-list__value">{{ showAmount($investment->initial_deposit) }}</span>
                        </li>
                        <li class="info-list__item">
                            <span class="info-list__label">@lang('Start Date')</span>
                            <span class="info-list__value">{{ showDateTime($investment->start_date) }}</span>
                        </li>
                        <li class="info-list__item">
                            <span class="info-list__label">@lang('End Date')</span>
                            <span class="info-list__value">{{ showDateTime($investment->end_date) }}</span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-xl-6 col-md-6">
            <div class="card custom--card h-100">
                <div class="card-header">
                    <h5 class="card-title mb-0">@lang('Contribution Details')</h5>
                </div>
                <div class="card-body">
                    <ul class="info-list">
                        <li class="info-list__item">
                            <span class="info-list__label">@lang('Contribution Amount')</span>
                            <span class="info-list__value">{{ showAmount($investment->contribution_amount) }}</span>
                        </li>
                        <li class="info-list__item">
                            <span class="info-list__label">@lang('Contribution Frequency')</span>
                            <span class="info-list__value">
                                @if ($investment->contribution_frequency == Status::DAILY_FREQUENCY)
                                    @lang('Daily')
                                @elseif($investment->contribution_frequency == Status::WEEKLY_FREQUENCY)
                                    @lang('Weekly')
                                @elseif($investment->contribution_frequency == Status::MONTHLY_FREQUENCY)
                                    @lang('Monthly')
                                @elseif($investment->contribution_frequency == Status::ANNUALLY_FREQUENCY)
                                    @lang('Annually')
                                @endif
                            </span>
                        </li>
                        <li class="info-list__item">
                            <span class="info-list__label">@lang('Next Contribution Date')</span>
                            <span class="info-list__value">{{ showDateTime($investment->next_contribution_date) }}</span>
                        </li>
                        <li class="info-list__item">
                            <span class="info-list__label">@lang('Total Paid Contributions')</span>
                            <span class="info-list__value">{{ $investment->paid_contribution }}
                                (@lang('out of '){{ $investment->contribution_count }})</span>
                        </li>
                        <li class="info-list__item">
                            <span class="info-list__label">@lang('Paid Contribution Amount')</span>
                            <span class="info-list__value">{{ showAmount($contributionAmount) }}</span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-xl-12 col-md-12">
            <div class="card custom--card">
                <div class="card-header">
                    <h5 class="card-title mb-0">@lang('Returns & Growth')</h5>
                </div>
                <div class="card-body">
                    <ul class="info-list">
                        <li class="info-list__item">
                            <span class="info-list__label">@lang('Year To Grow')</span>
                            <span class="info-list__value">{{ $investment->duration_years }} @lang('years')</span>
                        </li>
                        <li class="info-list__item">
                            <span class="info-list__label">@lang('Annual Return Rate')</span>
                            <span class="info-list__value">{{ getAmount($investment->annual_return_rate) }}%</span>
                        </li>
                        <li class="info-list__item">
                            <span class="info-list__label">@lang('Total Return')</span>
                            <span class="info-list__value">{{ showAmount($investment->total_return) }}</span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="row mt-4">
        <div class="col-lg-12">
            <div class="d-flex justify-content-between align-items-center mb-4 flex-wrap gap-2">
                <h5 class="mb-0">@lang('All Contributions')</h5>
                <form>
                    <div class="input-group">
                        <div class="form--control-wrapper">
                            <input type="search" name="search" class="form--control" value="{{ request()->search }}"
                                   placeholder="@lang('Search by transactions')">
                            <button class="input-group-text bg-primary text-white">
                                <i class="las la-search"></i>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
            @if (!blank($contributions))
                <div class="table-responsive">
                    <table class="table custom--table table--responsive--lg">
                        <thead>
                            <tr>
                                <th>@lang('TRX')</th>
                                <th class="text-center">@lang('Contribution Amount')</th>
                                <th class="text-center">@lang('Penalty Amount')</th>
                                <th class="text-center">@lang('Status')</th>
                                <th class="text-center">@lang('Contributed At')</th>
                            </tr>
                        </thead>
                        <tbody>

                            @forelse($contributions as $contribution)
                                <tr>
                                    <td>
                                        {{ $contribution->trx }}
                                    </td>
                                    <td class="text-center">
                                        {{ showAmount($contribution->amount) }}
                                    </td>
                                    <td class="text-center">
                                        {{ showAmount($contribution->penalty_amount) }}
                                    </td>
                                    <td class="text-center">
                                        @php echo $contribution->contributionStatusBadge @endphp
                                    </td>
                                    <td class="text-center">
                                        <div>
                                            {{ showDateTime($contribution->created_at) }} <br>
                                            {{ diffForHumans($contribution->created_at) }}
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            @else
                <div class="card custom--card">
                    <div class="card-body">
                        @include($activeTemplate . 'partials.empty', ['message' => 'No contribution yet'])
                    </div>
                </div>
            @endif
        </div>
    </div>
    @if ($contributions->hasPages())
        <div class="pagination-wrapper">
            {{ paginateLinks($contributions) }}
        </div>
    @endif
@endsection
