@extends($activeTemplate . 'layouts.master')

@section('content')
    <div class="card custom--card">
        <div class="card-body">
            <form method="post">
                @csrf
                <div class="form-group">
                    <label class="form-label">@lang('Current Password')</label>
                    <div class="form--control-wrapper">
                        <input type="password" class="form-control form--control" name="current_password" required
                               autocomplete="current-password">
                        <span class="password-show-hide fas toggle-password fa-eye-slash"></span>
                    </div>
                </div>
                <div class="form-group">
                    <label class="form-label">@lang('Password')</label>
                    <div class="form--control-wrapper">
                        <input type="password"
                               class="form-control form--control @if (gs('secure_password')) secure-password @endif"
                               name="password" required autocomplete="current-password">
                        <span class="password-show-hide fas toggle-password fa-eye-slash"></span>
                    </div>
                </div>
                <div class="form-group">
                    <label class="form-label">@lang('Confirm Password')</label>
                    <div class="form--control-wrapper">
                        <input type="password" class="form-control form--control" name="password_confirmation" required
                               autocomplete="current-password">
                        <span class="password-show-hide fas toggle-password fa-eye-slash"></span>
                    </div>
                </div>
                <div class="form-group mb-0">
                    <button type="submit" class="btn btn--base w-100">@lang('Submit')</button>
                </div>
            </form>
        </div>
    </div>
@endsection
@if (gs('secure_password'))
    @push('script-lib')
        <script src="{{ asset('assets/global/js/secure_password.js') }}"></script>
    @endpush
@endif

@push('style')
    <style>
        .hover-input-popup .input-popup {
            background-color: #2f2f2f !important;
        }

        .input-popup::after {
            border-color: transparent transparent #2f2f2f transparent !important;
        }
    </style>
@endpush
