@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="card custom--card">
        <div class="card-body">
            <form method="post" enctype="multipart/form-data">
                @csrf
                <div class="row">
                    <div class="form-group col-sm-12">
                        <div class="upload-thumb-wrapper">
                            <div class="upload-thumb mb-2">
                                <div class="upload-thumb-img">
                                    <input type="file" name="image" class="d-none" id="profile">
                                    <img src="{{ $user->image_src }}" class="fit-image" alt="@lang('image')"
                                        id="profile-preview">
                                </div>
                                <label class="upload-thumb-btn" for="profile">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                        viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                        stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-image-up">
                                        <path
                                            d="M10.3 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2v10l-3.1-3.1a2 2 0 0 0-2.814.014L6 21" />
                                        <path d="m14 19.5 3-3 3 3" />
                                        <path d="M17 22v-5.5" />
                                        <circle cx="9" cy="9" r="2" />
                                    </svg>
                                </label>
                            </div>
                            <p class="mb-2 text-center text--base">
                                @lang('Image size:') <span class="text--danger">{{ getFileSize('userProfile') }}</span> |
                                @lang('Allowed Extensions:') <span class="text--danger">@lang('jpg, jpeg, png')</span>
                            </p>
                        </div>
                    </div>
                    <div class="form-group col-sm-6">
                        <label class="form-label">@lang('First Name')</label>
                        <div class="form--control-wrapper">
                            <input type="text" class="form-control form--control" name="firstname"
                                value="{{ $user->firstname }}" required>
                        </div>
                    </div>
                    <div class="form-group col-sm-6">
                        <label class="form-label">@lang('Last Name')</label>
                        <div class="form--control-wrapper">
                            <input type="text" class="form-control form--control" name="lastname"
                                value="{{ $user->lastname }}" required>
                        </div>
                    </div>
                    <div class="form-group col-sm-6">
                        <label class="form-label">@lang('E-mail Address')</label>
                        <div class="form--control-wrapper">
                            <input class="form-control form--control" value="{{ $user->email }}" readonly>
                        </div>
                    </div>
                    <div class="form-group col-sm-6">
                        <label class="form-label">@lang('Mobile Number')</label>
                        <div class="form--control-wrapper">
                            <input class="form-control form--control" value="{{ $user->mobile }}" readonly>
                        </div>
                    </div>
                    <div class="form-group col-sm-6">
                        <label class="form-label">@lang('Address')</label>
                        <div class="form--control-wrapper">
                            <input type="text" class="form-control form--control" name="address"
                                value="{{ $user->address }}">
                        </div>
                    </div>
                    <div class="form-group col-sm-6">
                        <label class="form-label">@lang('State')</label>
                        <div class="form--control-wrapper">
                            <input type="text" class="form-control form--control" name="state"
                                value="{{ $user->state }}">
                        </div>
                    </div>
                    <div class="form-group col-sm-4">
                        <label class="form-label">@lang('Zip Code')</label>
                        <div class="form--control-wrapper">
                            <input type="text" class="form-control form--control" name="zip"
                                value="{{ $user->zip }}">
                        </div>
                    </div>

                    <div class="form-group col-sm-4">
                        <label class="form-label">@lang('City')</label>
                        <div class="form--control-wrapper">
                            <input type="text" class="form-control form--control" name="city"
                                value="{{ $user->city }}">
                        </div>
                    </div>

                    <div class="form-group col-sm-4">
                        <label class="form-label">@lang('Country')</label>
                        <div class="form--control-wrapper">
                            <input class="form-control form--control" value="{{ $user->country_name }}" disabled>
                        </div>
                    </div>
                    <div class="form-group mb-0 col-sm-12">
                        <button type="submit" class="btn btn--base w-100">@lang('Submit')</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection


@push('script')
    <script>
        "use strict";
        (function($) {
            $('#profile').on('change', function(event) {
                var file = event.target.files[0];
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#profile-preview').attr('src', e.target.result).fadeOut().fadeIn();
                };
                if (file) {
                    reader.readAsDataURL(file);
                }
            });
        })(jQuery);
    </script>
@endpush
